#include <stdio.h>     /* for 'perror'  */
#include <stdlib.h>    /* for 'exit'    */
#include <string.h>    /* for 'memset'  */
#include <unistd.h>    /* for 'close'   */

#include <sys/types.h>   /*  \  for raw      */
#include <sys/socket.h>  /*  /  sockets      */
#include <netinet/in.h>  /* \  for inet_aton */
#include <arpa/inet.h>   /* /                */

#include <netinet/ip_icmp.h> /* for struct icmphdr */

#include "in_cksum.h"

int main(int argc, char* argv[])
{
    int rc;
    int s = -1;
    struct sockaddr_in addr;
    struct icmphdr icmphdr;
   
    s = socket(PF_INET, SOCK_RAW, IPPROTO_ICMP);
    if (s == -1) {
	perror("socket:");
	exit(1);
    }

    // first, clear out the ICMP header.
    memset(&icmphdr, 0, sizeof(struct icmphdr));

    // now, fill in the parameters for an "echo" request.
    icmphdr.type = ICMP_ECHO;
    icmphdr.un.echo.sequence = 50;
    icmphdr.un.echo.id = 48;
    icmphdr.checksum =
	in_cksum((unsigned short*)&icmphdr, sizeof(struct icmphdr));

    // prepare the address we're sending the packet to.
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    inet_aton("127.0.0.1", &addr.sin_addr);

    // finally, send the packet.
    rc = sendto(s,
		&icmphdr,
		sizeof(struct icmphdr),
		0 /* flags */,
		(struct sockaddr*)&addr,
		sizeof(addr));
    if (rc == -1) {
	perror("sendto:");
	exit(1);
    }

    close(s);

    return 0;
}
