#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>  /* \  for inet_aton */
#include <arpa/inet.h>   /* /                */

#include <netinet/ip_icmp.h>

#include "in_cksum.h"

int main(int argc, char* argv[])
{
    int rc;
    int s = -1;
    struct sockaddr_in addr, raddr;
    socklen_t raddr_len;
    struct iphdr* iphdr = NULL;
    struct icmphdr* icmphdr = NULL;
    char buf[sizeof(struct icmp)];
    char rbuf[sizeof(struct iphdr) + sizeof(struct icmp)];
   
    s = socket(PF_INET, SOCK_RAW, IPPROTO_ICMP);
    if (s == -1) {
	perror("socket:");
	exit(1);
    }

    // for now, we only need to supply the ICMP header.
    icmphdr = (struct icmphdr*)buf;

    // first, clear out the ICMP header.
    memset(icmphdr, 0, sizeof(struct icmphdr));

    // now, fill in the parameters for an "echo" request.
    icmphdr->type = ICMP_ECHO;
    icmphdr->un.echo.sequence = 50;
    icmphdr->un.echo.id = 48;
    icmphdr->checksum =
	in_cksum((unsigned short*)icmphdr, sizeof(struct icmphdr));

    // prepare the address we're sending the packet to.
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    inet_aton("127.0.0.1", &addr.sin_addr);

    // finally, send the packet.
    rc = sendto(s,
		buf,
		sizeof(struct icmphdr),
		0 /* flags */,
		(struct sockaddr*)&addr,
		sizeof(addr));
    if (rc == -1) {
	perror("sendto:");
	exit(1);
    }

    // receive the packet that we sent (since we sent it to ourselves,
    // and a raw socket sees everything...).
    rc = recvfrom(s, rbuf, sizeof(rbuf), 0, (struct sockaddr*)&raddr, &raddr_len);
    if (rc == -1) {
	perror("recvfrom 1:");
	exit(1);
    }

    // receive the reply.
    memset(rbuf, 0, sizeof(rbuf));
    rc = recvfrom(s, rbuf, sizeof(rbuf), 0, (struct sockaddr*)&raddr, &raddr_len);
    if (rc == -1) {
	perror("recvfrom 2:");
	exit(1);
    }

    // we got an IP packet - verify that it contains an ICMP message.
    iphdr = (struct iphdr*)rbuf;
    if (iphdr->protocol != IPPROTO_ICMP) {
	fprintf(stderr, "Expected ICMP packet, got %u\n", iphdr->protocol);
	exit(1);
    }
    
    // verify that it's an ICMP echo reply, with the expected seq. num + id.
    icmphdr = (struct icmphdr*)(rbuf + (iphdr->ihl * 4));
    if (icmphdr->type != ICMP_ECHOREPLY) {
	fprintf(stderr, "Expected ICMP echo-reply, got %u\n", icmphdr->type);
	exit(1);
    }
    if (icmphdr->un.echo.sequence != 50) {
	fprintf(stderr,
		"Expected sequence 50, got %d\n", icmphdr->un.echo.sequence);
	exit(1);
    }
    if (icmphdr->un.echo.id != 48) {
	fprintf(stderr,
		"Expected id 48, got %d\n", icmphdr->un.echo.id);
	exit(1);
    }
    printf("Got the expected ICMP echo-reply\n");

    close(s);

    return 0;
}
