#include "HelloWorldImpl.h"

#include <string.h>
#include <iostream.h>


//Constructor
HelloWorldImpl::HelloWorldImpl(PortableServer::POA_ptr poa)
  : myPoa (PortableServer::POA::_duplicate (poa))
{
}

//Destructor
HelloWorldImpl::~HelloWorldImpl(void)
{
}

// Returns the default POA of this object
PortableServer::POA_ptr
HelloWorldImpl::_default_POA()
{
    return myPoa;
}

// write a "hello world" message to the screen.
void
HelloWorldImpl::sayHello()
{
    cout << "Hello World" << endl << flush;
}
 
// write the given message to the screen.
void
HelloWorldImpl::sayMessage(const char* a_message)
{
    if (a_message)
	cout << "Message: " << a_message << endl << flush;
}

// returns a random true or false value.
CORBA::Boolean
HelloWorldImpl::isTheWorldSafe()
{
    // ok, so i'm lazy - too lazy to use rand()...
    return 1;
}

// print out a prmopt, and read a message from the user.
// stores the message in 'message', and returns the length of the message.
// Reads num_bytes from standard input and returns it
CORBA::Long
#ifdef __TAO__
HelloWorldImpl::readMessage(const char* prompt,
      			    CORBA::String_out message)
#else
HelloWorldImpl::readMessage(const char* prompt,
      			    char*& message)
#endif
{
    // print out a prompt.
    cout << (prompt ? prompt : "Input:") << flush;
    // read input from STDIN.
    char buf[1024];
    cin >> buf;
    // buf's contents is copied into 'message'.
    message = CORBA::string_dup(buf);
#ifdef __TAO__
    cout << "Returning '" << message.ptr() << "'" << endl << flush;
#else
    cout << "Returning '" << message << "'" << endl << flush;
#endif

    return strlen(buf);
}
