#!/usr/bin/perl

#
# This script requires Ghostscript (gs) and the convert utility.
# AND a lot of temporary disk space and CPU time.
#

$file=shift;

($file=~/.*?([^\/]+)\.ps/i) ||
  die "Filename should have a .ps suffix!";

$fname=$1;

(-e $file) || die "PS file doesn't exist!";

# Run ghostscript to convert the file to PPM format
# The /dev/null is used to supply gs with the EOF it needs to terminate

`gs -q -dSAFER -dNOPAUSE -sDEVICE=ppm -r150x150 -sOutputFile=$fname%02d.ppm $file < /dev/null`;

for ($i=1; ; $i++) {
  $num=sprintf('%02d',$i);
  (-e "$fname$num.ppm") || last;
  `convert -blur 99 -sample 600x800 -rotate -90 $fname$num.ppm $fname$num.gif`;
  unlink "$fname$num.ppm";
}
