#include <stdio.h>
#include <gtk/gtk.h>

/*
 * callback event function for the gtk delete event. invoked
 * when the application is closed using the window manager.
 */
int
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    /* If you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs.
     */
 
    return(FALSE);
}


/* exit the application. */
void
exit_cb(GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

/* "hellow world" button "clicked" callback function. */
void
on_button1_clicked(GtkButton* button, gpointer data)
{
    /* cast the data back to a char*  */
    char* txt = (char*)data;
    printf("on_button_clicked - '%s'\n", txt);
    fflush(stdout);
}

/* "quit" button "clicked" callback function. */
void
on_button2_clicked(GtkButton* button, gpointer data)
{
    /* make sure we realy quit. */
    gtk_main_quit();
}

int
main(int argc, char* argv[])
{
    /* this variable will store a pointer to the window object. */
    GtkWidget* main_window;
    /* this will store a horizontal box. */
    GtkWidget* hbox;
    /* these will store push buttons. */
    GtkWidget* button1;
    GtkWidget* button2;


    /* This is called in all GTK applications. Arguments */
    /* are parsed from the command line and are returned */
    /* to the application.                               */
    gtk_init(&argc, &argv);

    /* create a new top-level window. */
    main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    /* define some of the window's attributes. */
    gtk_window_set_title(GTK_WINDOW (main_window),
                         "A Top Window For The Rest Of Us...");
    gtk_container_set_border_width(GTK_CONTAINER (main_window), 5);

    /* make the window visible. */
    gtk_widget_show(main_window);

    /* When the window is given the "delete_event" signal (this is given
     * by the window manager, usually by the "close" option, or on the
     * titlebar), we ask it to call the delete_event() function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "delete_event",
                       GTK_SIGNAL_FUNC (delete_event), NULL);

    /* Here we connect the "destroy" event to a signal handler.
     * This event occurs when we call gtk_widget_destroy() on the window,
     * or if we return FALSE in the "delete_event" callback.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "destroy",
                       GTK_SIGNAL_FUNC (exit_cb), NULL);

    /* create a new horizontal box, and add to top-level window. */
    hbox = gtk_hbox_new(TRUE, 20);
    gtk_container_add(GTK_CONTAINER(main_window), hbox);
    gtk_widget_show(hbox);

    /* create a button. */
    button1 = gtk_button_new_with_label("Hello World");

    /* make the button visible. */
    gtk_widget_show(button1);

    /* pack our button inside the hbox. */
    gtk_box_pack_start(GTK_BOX(hbox), button1, FALSE, TRUE, 1);

    /* set a callback for the 'clicked' signal of the button.    */
    /* the given gpointer will be passed as the 'data' parameter */
    /* to the callback.                                          */
    gtk_signal_connect(GTK_OBJECT(button1), "clicked",
                       GTK_SIGNAL_FUNC(on_button1_clicked),
                       (gpointer)"tough");

    /* create a second button, place it in the hbox, and attach */
    /* a different callback.                                    */
    button2 = gtk_button_new_with_label("Quit");
    gtk_widget_show(button2);
    gtk_box_pack_start(GTK_BOX(hbox), button2, FALSE, TRUE, 1);
    gtk_signal_connect(GTK_OBJECT(button2), "clicked",
                       GTK_SIGNAL_FUNC(on_button2_clicked),
                       (gpointer)NULL);

    /* All GTK applications must have a gtk_main(). Control
     * ends here and waits for an event to occur (like a
     * key press or mouse event).
     */
    gtk_main();

    exit(0);
}
