#include <gtk/gtk.h>

/*
 * callback event function for the gtk delete event. invoked
 * when the application is closed using the window manager.
 */
int
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    /* If you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs.
     */
 
    return(FALSE);
}


/* exit the application. */
void
exit_cb(GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

int
main(int argc, char* argv[])
{
    /* this variable will store a pointer to the window object. */
    GtkWidget* main_window;
    /* this will store a horizontal box. */
    GtkWidget* hbox;
    /* this will store a frame. */
    GtkWidget* frame;
    /* this will store the frame's geometry manager. */
    GtkWidget* frame_hbox;
    /* these will store widgets to be placed in the frame. */
    GtkWidget* button;
    GtkWidget* label;
    GtkWidget* entry;


    /* This is called in all GTK applications. Arguments */
    /* are parsed from the command line and are returned */
    /* to the application.                               */
    gtk_init(&argc, &argv);

    /* create a new top-level window. */
    main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    /* define some of the window's attributes. */
    gtk_window_set_title(GTK_WINDOW (main_window),
                         "A Top Window For The Rest Of Us...");
    gtk_container_set_border_width(GTK_CONTAINER (main_window), 5);

    /* make the window visible. */
    gtk_widget_show(main_window);

    /* When the window is given the "delete_event" signal (this is given
     * by the window manager, usually by the "close" option, or on the
     * titlebar), we ask it to call the delete_event() function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "delete_event",
                       GTK_SIGNAL_FUNC (delete_event), NULL);

    /* Here we connect the "destroy" event to a signal handler.
     * This event occurs when we call gtk_widget_destroy() on the window,
     * or if we return FALSE in the "delete_event" callback.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "destroy",
                       GTK_SIGNAL_FUNC (exit_cb), NULL);

    /* create a new horizontal box, make it non-homogenous, */
    /* and with 0 spacing between its contained widgets.    */
    /* place it in the top window, make it visible.	    */
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(main_window), hbox);
    gtk_widget_show(hbox);

    /* create a frame. place it in the hbox, and make it visible. */
    frame = gtk_frame_new("Host Information");
    gtk_frame_set_label_align(GTK_FRAME(frame), 0.15, 0.0);
    gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 1);
    gtk_widget_show(frame);
    
    /* place a hbox inside the frame. */
    frame_hbox = gtk_hbox_new(FALSE, 10);
    gtk_container_add(GTK_CONTAINER(frame), frame_hbox);
    gtk_widget_show(frame_hbox);

    /* create a few widgets, place them in the frame's hbox. */
    /* in the box, and have 1 pixel of padding on each size. */
    button = gtk_button_new_with_label("Add");
    gtk_widget_show(button);

    label = gtk_label_new("Host:");
    gtk_widget_show(label);

    entry = gtk_entry_new_with_max_length(30);
    gtk_widget_show(entry);

    gtk_box_pack_start(GTK_BOX(frame_hbox), label, FALSE, FALSE, 3);
    gtk_box_pack_start(GTK_BOX(frame_hbox), entry, TRUE, TRUE, 3);
    gtk_box_pack_start(GTK_BOX(frame_hbox), button, FALSE, FALSE, 3);


    /* All GTK applications must have a gtk_main(). Control
     * ends here and waits for an event to occur (like a
     * key press or mouse event).
     */
    gtk_main();

    exit(0);
}
