#include <stdio.h>
#include <gtk/gtk.h>

/*
 * callback event function for the gtk delete event. invoked
 * when the application is closed using the window manager.
 */
int
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    /* If you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs.
     */
 
    return(FALSE);
}


/* exit the application. */
void
exit_cb(GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

/* print an 'about' message - to stdout. */
void
about_cb(GtkWidget *widget, gpointer data)
{
    printf("About....\n");
    fflush(stdout);
}

int
main(int argc, char* argv[])
{
    /* this variable will store a pointer to the window object. */
    GtkWidget* main_window;
    /* this will store a horizontal box. */
    GtkWidget* hbox;
    /* this will hold the menu bar. */
    GtkWidget* menu_bar;
    /* this will hold the 'file' menu item. */
    GtkWidget* menu_file_item;
    /* this will hold the 'file' menu. */
    GtkWidget* menu_file;
    /* this will hold the 'quit' item of the 'file' menu. */
    GtkWidget* menu_file_quit;
    /* the same, for a 'help' menu. */
    GtkWidget* menu_help_item;
    GtkWidget* menu_help;
    GtkWidget* menu_help_about;


    /* This is called in all GTK applications. Arguments */
    /* are parsed from the command line and are returned */
    /* to the application.                               */
    gtk_init(&argc, &argv);

    /* create a new top-level window. */
    main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    /* define some of the window's attributes. */
    gtk_window_set_title(GTK_WINDOW (main_window),
                         "A Top Window For The Rest Of Us...");
    gtk_container_set_border_width(GTK_CONTAINER (main_window), 5);

    /* make the window visible. */
    gtk_widget_show(main_window);

    /* When the window is given the "delete_event" signal (this is given
     * by the window manager, usually by the "close" option, or on the
     * titlebar), we ask it to call the delete_event() function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "delete_event",
                       GTK_SIGNAL_FUNC (delete_event), NULL);

    /* Here we connect the "destroy" event to a signal handler.
     * This event occurs when we call gtk_widget_destroy() on the window,
     * or if we return FALSE in the "delete_event" callback.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "destroy",
                       GTK_SIGNAL_FUNC (exit_cb), NULL);

    /* create a new horizontal box, make it non-homogenous,   */
    /* and with 0 spacing between its contained widgets.      */
    /* place it in the top-level window, and make it visible. */
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(main_window), hbox);
    gtk_widget_show(hbox);


    /* create a new menu bar. make it visible. add it to the top-window. */
    menu_bar = gtk_menu_bar_new();
    gtk_widget_show(menu_bar);
    gtk_box_pack_start(GTK_BOX(hbox), menu_bar, TRUE, TRUE, 1);

    /* create a 'file' menu for our menu bar. */
    menu_file = gtk_menu_new();

    /* create a 'quit' menu item, give it an 'activate' callback. */
    menu_file_quit = gtk_menu_item_new_with_label("Quit");
    gtk_widget_show(menu_file_quit);
    gtk_signal_connect_object(GTK_OBJECT(menu_file_quit), "activate",
                              GTK_SIGNAL_FUNC(exit_cb), NULL);

    /* add the 'quit' option to the 'file' menu. */
    gtk_menu_append(GTK_MENU(menu_file), menu_file_quit);

    /* make the 'file' menu visible, for when it pops up. */
    gtk_widget_show(menu_file);

    /* make a 'file' menu_item, and make it visible. */
    menu_file_item = gtk_menu_item_new_with_label("File");
    gtk_widget_show(menu_file_item);

    /* set the 'file' menu as the sub-menu of the 'file' menu_item. */
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_file_item), menu_file);

    /* append the 'file' menu item to the menu bar. */
    gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_file_item);

    /* create a 'help' menu in a similar manner. */
    menu_help = gtk_menu_new();
    menu_help_about = gtk_menu_item_new_with_label("About");
    gtk_widget_show(menu_help_about);
    gtk_signal_connect_object(GTK_OBJECT(menu_help_about), "activate",
                              GTK_SIGNAL_FUNC(about_cb), NULL);
    gtk_menu_append(GTK_MENU(menu_help), menu_help_about);
    gtk_widget_show(menu_help);
    menu_help_item = gtk_menu_item_new_with_label("Help");
    gtk_menu_item_right_justify(GTK_MENU_ITEM(menu_help_item));
    gtk_widget_show(menu_help_item);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_help_item), menu_help);
    gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_help_item);

    /* All GTK applications must have a gtk_main(). Control
     * ends here and waits for an event to occur (like a
     * key press or mouse event).
     */
    gtk_main();

    exit(0);
}
