/**********************************************************************
                                                                     
   Copyright (C) 2002,2003 Emil D. Kohn   emild@cs.technion.ac.il     
                                                                     
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 **********************************************************************/


#ifndef SAR_H
#define SAR_H

#include "defs.h"

/* Precede each PPP frame with the 
   address and control bytes (RFC 1661) */
#define USE_ADDRESS_AND_CONTROL


/* Prototype of a callback function which should fill the buffer */
typedef int (*reader_function)(u8 buffer[], int buffer_size);

int sar_init(u8 vpi, u16 vci);


/* return value: actual cell buffer size */
/* Implementation oddities (also known as BUGS ;-)
   1. The size of the ppp_frame buffer should be at least 
   least frame_buffer_size, which should be greater or equal 
   than frame_size + 48 bytes. frame_size is equal to the actual
   PPP frame.
   2. ppp_frame[] is supposed to be const. The buffer
   itself is not changed (except for the last two bytes
   containing the checksum), starting from which
   the following 48 bytes are  overwritten (zero padding 
   and length are appened)  in order to calculate the checksum

   PHEW, that's ugly!! I'll fix it in the next version.
   I promise. You believe ;-)
*/

int segmentation(u8 ppp_frame[], int frame_size, int frame_buffer_size,
		 u8 cell_buffer[], int cell_buffer_size);


/* read a PPP frame from the USB device, using the cell_buffer
   for temporary storage. The size of the cell  buffer must be a 
   multiple of RX_CELL_SIZE. The cell buffer is circular. head
   and tail point to its start and end. Upon the first call
   to this function both head and tail must point to a pointer to
   the start of the buffer. After that, the function correctly
   (ignoring the bugs, of course ;-) updates head and tail.
   The caller of the function should not care too much about
   them, just to make sure that their values are not altered 
   across calls. The return value is the actual size of the 
   PPP frame. When the buffer is empty, the reader_function
   callback is invoked to fill the buffer.
*/
int reassembly(u8 cell_buffer[], int cell_buffer_size,
	       u8** head, u8** tail,
	       u8 ppp_frame[], int ppp_frame_buffer_size,
	       reader_function callback);

#endif /* SAR_H */
