/**********************************************************************
                                                                     
   Copyright (C) 2002,2003 Emil D. Kohn   emild@cs.technion.ac.il     
                                                                     
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 **********************************************************************/



#ifndef ATM_CRC_H
#define ATM_CRC_H


/* 
   Initialize ATM cell header. 
   - GFC (generic flow control) is set to zero
   - VCI (virtual circuit identifier)  and VPI (virtual path identifier)
     are initialized according to the parameters received
   - the PT (payload type, including AAU flag (aka no more data) and 
     HEC (header error check) are set to zero 
     
   header_size must be set to 5
 */
int  atm_cell_header_init(u8 vpi, u16 vci, 
			  u8 cell_header[], int header_size);

/* ATM cell header error check   as per ITU rec. I432 */
/* nbytes *MUST* be 4 */
u8 atm_hec(const u8 data[], int nbytes);

/* CRC-32 as per ITU rec. I363.5 */
u32 atm_crc(const u8 data[], int nbytes);

#endif  /* ATM_CRC_H */
