#include <stdio.h>
#include <stdlib.h>
#include <time.h>   /* for time(), to generate randomness. */

#include <linux/netfilter.h>  /* \ for libipq methods */
#include <libipq.h>           /* / and types.         */

#define BUFSIZE 2048

int main(int argc, char* argv[])
{
    int drop_percent = 20;
    unsigned char buf[BUFSIZE];
    struct ipq_handle *h = NULL;
    int rc;

    srand(time(NULL));

    // initialize libipq.
    h = ipq_create_handle(0, PF_INET);
    if (!h) {
	ipq_perror("ipq_create_handle:");
	exit(1);
    }

    // set the queuing mode.
    rc = ipq_set_mode(h, IPQ_COPY_PACKET, BUFSIZE);
    if (rc < 0) {
	ipq_perror("ipq_set_mode:");
        ipq_destroy_handle(h);
	exit(1);
    }

    // loop forever, reading packets.
    while (1) {
	int msg_type;

	rc = ipq_read(h, buf, BUFSIZE, 0);
	if (rc < 0) {
	    ipq_perror("ipq_read:");
            ipq_destroy_handle(h);
	    exit(1);
	}

	msg_type = ipq_message_type(buf);
	switch (msg_type) {
	    case NLMSG_ERROR:
		fprintf(stderr,
			"ipq_read got error %d",
			ipq_get_msgerr(buf));
		break;
	    case IPQM_PACKET:
	        {
    		    int verdict = NF_ACCEPT;
    	            ipq_packet_msg_t* msg = ipq_get_packet(buf);
		    if (rand() % 100 < drop_percent) {
			printf("D");
			fflush(stdout);
		        verdict = NF_DROP;
		    }
		    rc = ipq_set_verdict(h, msg->packet_id, verdict, 0, NULL);
	        }
	        break;
	    default:
		fprintf(stderr, "unknown ipq msg type %d\n", msg_type);
	}
    }

    ipq_destroy_handle(h);

    return 0;
}
