#!/usr/bin/perl
# Usage: getclearmind {album-number}

use warnings;
use HTTP::Request::Common qw(POST);
use HTTP::Cookies;
use LWP::UserAgent;

$arg = shift;
$arg += 0;

die("Bad album number\n")
  if ($arg == 0);

$basedir = 'http://www.clearmind.co.il/';
$baseurl = $basedir.'gallery.asp?GalleryID='.$arg.'&Page=';

# Create a cookie jar and log into the server

$ua = LWP::UserAgent->new;

$ua->agent("Mozilla/8.0"); # pretend we are very capable browser
$jar = HTTP::Cookies->new(file => "clearmindcookies.txt",
			  autosave => 1);
$ua->cookie_jar($jar);

my $req = POST $basedir.'login.asp',
  [ username => 'my_user_name',
    password => 'my_password'
  ];
print "Now logging in...\n";
$res = $ua->request($req);

# We're not really interested in the result.
# This was only a cookie thing.

die "Error: " . $res->status_line . "\n"
  unless ($res->is_success);

$page = 0;
@allimgs = ();

while (1) {
  $page++;
  my $req = HTTP::Request->new(GET => $baseurl.$page);
  print STDERR "Grabbing page $page of album $arg... ";
  $res = $ua->request($req);
  if ($res->is_success) {
    $data = $res->content;
    @imgpairs = ($data =~ /getpic\.asp\?Path=(.*?)\/thumbs.*?Pic=(.*?)\" onClick/ig);
    if ($#imgpairs < 0) {
      print STDERR "OK, the previous was the last one.\n";
      last;
    }    

    push @allimgs, @imgpairs;
    print STDERR "OK!\n";
  }
  else {
    print STDERR "fatal error!\n";
    die("Failed in attempt to read album page\n");
  }
}

$num = @allimgs; $num /= 2;
die("No images found in album. (Login failed?)\n")
  if ($num == 0);

$nicename = $allimgs[0]; # The first element is the path

$dir = "clearmind-album$arg-$nicename";
$dir =~ s/%([0-9a-fA-F]{2})/chr(hex($1))/ge;

die("File/directory '$dir' already exists\n")
  if (-e $dir);

die("Failed to create '$dir'\n")
  unless (mkdir $dir);

die("Failed to change directory to '$dir'\n")
  unless (chdir $dir);

print STDOUT "Getting $num images...";

IMG: while (@allimgs) {
  my $path = shift @allimgs;
  my $pic = shift @allimgs;

  for ($i=0; $i<3; $i++) {
    print "Now getting $pic...";
    
    my $req = HTTP::Request->new(GET => $basedir."global/getpic.asp?Path=$path&Pic=$pic" );
    
    $res = $ua->request($req, $pic);
    if ($res->is_success) {
      print "OK, file is ".(-s $pic)." bytes\n";
      next IMG;
    } else {
      print "FAILED!\n";
    }
  }
}

