#!/usr/bin/perl
use Tk;
use LWP::UserAgent;
use warnings;

$SIG{__WARN__} = sub { };

$pagecontent = '';

setup_main_window();

MainLoop;

sub setup_main_window {
  $main_window = MainWindow->new;
  $main_window->title( "Web regular expression dev tool" );
  $font = 'Courier';

  $frame_url   = $main_window->Frame( -borderwidth => 2, -relief => 'groove' );
  $frame_expression = $main_window->Frame( -borderwidth => 2, -relief => 'groove' );
  $frame_results   = $main_window->Frame( -borderwidth => 2, -relief => 'groove' );

  $frame_url  ->pack( -side => 'top', -padx => 2, -pady => 2, -anchor => 'n', -expand => 0, -fill => 'x'    );
  $frame_results  ->pack( -side => 'top', -padx => 2, -pady => 2, -anchor => 'n', -expand => 1, -fill => 'both' );
  $frame_expression  ->pack( -side => 'top', -padx => 2, -pady => 2, -anchor => 'n', -expand => 1, -fill => 'both' );

  # url frame
  $url_label     = $frame_url->Label( -font => $font, -text => 'URL' );
  $url_entry     = $frame_url->Entry( -font => $font );
  $url_button    = $frame_url->Button( -text => 'Fetch!', -command => \&fetchpage );
  $url_entry -> insert('end', 'http://');

  $url_label    ->pack( -side => 'left', -padx => 2, -pady => 2 );
  $url_entry    ->pack( -side => 'left', -padx => 2, -pady => 2, -fill => 'x', -expand => 1 );
  $url_button   ->pack( -side => 'left', -padx => 2, -pady => 2 );

  # expression frame
  $expression_text  =     $frame_expression->Text(  -font => $font, -height => 5 );
  $expression_scrollbar = $frame_expression->Scrollbar( -orient => 'vertical', -command => [ 'yview' => $expression_text ] );
  $expression_text->configure( -yscrollcommand => [ $expression_scrollbar => 'set' ] );
  $expression_button    = $frame_expression->Button( -text => 'Run the scriptlet', -command => \&run_script );

  $expression_button   ->pack( -side => 'top', -padx => 2, -pady => 2, -fill => 'y' );
  $expression_scrollbar->pack( -side => 'right', -padx => 2, -pady => 2, -fill => 'y' );
  $expression_text     ->pack( -side => 'left',  -padx => 2, -pady => 2, -fill => 'both', -expand => 1 );

  # results frame
  $results_text  =     $frame_results->Text(  -font => $font, -height => 19 );
  $results_scrollbar = $frame_results->Scrollbar( -orient => 'vertical', -command => [ 'yview' => $results_text ] );
  $results_text->configure( -yscrollcommand => [ $results_scrollbar => 'set' ] );

  $results_scrollbar->pack( -side => 'right', -padx => 2, -pady => 2, -fill => 'y' );
  $results_text     ->pack( -side => 'left',  -padx => 2, -pady => 2, -fill => 'both', -expand => 1 );

  $results_text->tagConfigure( 'red', foreground => 'red' );

  $results_text->insert( 'end', 'Pick a URL and make a scriptlet!' );
}

sub run_script {
  my $script = $expression_text->get( '1.0', 'end' );

  my $toexec ='$_=$main::pagecontent;'."\npackage void;\n# line 1 scriptlet\n$script";
 
  @warnings = ();
  $SIG{__WARN__} = sub { push @warnings, $_[0]; };
 
  my @result = eval $toexec;  

  $SIG{__WARN__} = sub { };

  if( $@ ) {
    output("Error:\n\n$@", 'red');
    show_warnings();
  } elsif ((scalar @result) > 100) {
    show_warnings();
    $results_text->insert( 'end',
			   "Warning: ".(scalar @result)." members in list. Showing only first 100.\n\n".
			   join("\n", @result[0..99]),
			   'black' );
  } else {
    $results_text->delete( '0.0', 'end' ); 
    show_warnings();
    $results_text->insert( 'end', join("\n", @result), 'black' );
  }

  # Cute. Now clean up the "void" namespace, so we won't mess up
  *stash = *{"void::"};
  foreach ( keys %stash )
    {
      *alias = $stash{$_};
      undef $alias if( defined $alias );
      undef @alias if( defined @alias );
      undef %alias if( defined %alias );
    }
}

sub fetchpage {
  my $url = $url_entry->get;

  ($url) = ($url =~ /^[ \t\r\n]*(.*?)[ \t\r\n]*$/);
 
  my $ua = LWP::UserAgent->new;
  $ua->agent('Mozilla/4.0.(compatible;.MSIE.6.0;.Windows.NT.5.0)'); # Pretend to be Explorer

  my $req = HTTP::Request->new(GET => $url);

  output("Getting $url...", 'green');
  $main_window->update;

  my $res = $ua->request($req);
  
  if ($res->is_success) {
    $pagecontent = $res->content;
    output($pagecontent);
  } else {
    $pagecontent = "";
    output("Failed to fetch $url:\n\n" . $res->status_line, 'red') ;
  }
}

sub output {
  my ($val, $color) = @_;
  $color = 'black' unless (defined $color);
  $results_text->delete( '0.0', 'end' ); 
  $results_text->insert( 'end', $val, $color );
}

sub show_warnings {
  return unless (scalar @warnings);

  my $num = scalar @warnings;
  my $text;

  if ($num > 3) {
    $text = "There were $num warnings. Showing only first three:\n\n";
    splice @warnings, 3;
  } else {
    $text = "There were warnings as follows:\n\n";
  }  
  $results_text->insert( 'end', $text.join("\n", @warnings)."\n", 'red' );  
}
