#ifndef __HelloWorldImpl_h__
# define __HelloWorldImpl_h__

#ifdef __MICO__
# include <HelloWorld.h>
#endif
#ifdef __TAO__
# include <HelloWorldS.h>
#endif

class HelloWorldImpl : public POA_HelloWorld
{
  public:
    //Constructor
    HelloWorldImpl (PortableServer::POA_ptr poa);

    //Destructor
    virtual ~HelloWorldImpl (void);

    // Returns the default POA of this object
    PortableServer::POA_ptr _default_POA ();

    // write a "hello world" message to the screen.
    virtual void sayHello ();
 
    // write the given message to the screen.
    virtual void sayMessage(const char* a_message);

    // randomally return a boolean result.
    virtual CORBA::Boolean isTheWorldSafe();

    // prints out the given prompt, reads a message from standard input,
    // and returns that to the caller. the function's return value is the
    // length of the returned string.
#ifdef __TAO__
    virtual CORBA::Long readMessage(const char* prompt,
      				    CORBA::String_out message);
#else
    virtual CORBA::Long readMessage(const char* prompt,
      				    char*& message);
#endif

  private:
    PortableServer::POA_var myPoa;
};

#endif // __HelloWorldImpl_h__
