extern "C" char *cuserid (char *__s);

#include <fstream.h>

#ifdef __MICO__
# include <HelloWorld.h>
#endif
#ifdef __TAO__
# include <HelloWorldC.h>
#endif


#define DEFAULT_IOR_INPUT_FILE "HelloWorld.ior"

int main(int argc, char* argv[])
{
    const char* ior_input_file = DEFAULT_IOR_INPUT_FILE;
    char buf[1024];
    char* ior = 0;

    // Initialize the ORB.
    CORBA::ORB_var orb;
    try {
        orb = CORBA::ORB_init (argc, argv, "");
    }
    catch (CORBA::SystemException exception) {
        cerr << "CORBA::ORB_init";
        return -1;
    }

    // Read the file in which the server stored the IOR, and get the IOR.
    ifstream f(ior_input_file);

    if (f.good()) {

	f >> buf;
	if (!buf[0]) {
	    cerr << "Unable to read ior" << endl;
	    return -1;
	}
        ior = ::strdup(buf);
    }
    else {
	cerr << "Cannot open input file for reading IOR: '"
		           << ior_input_file << "'" << endl;
	return -1;
    }
  
    // translate the IOR to a reference to a CORBA object.
    // this is a blocking method that involves accessing the server process.
    CORBA::Object_var object;
    try {
        object = orb->string_to_object (ior);
    }
    catch (CORBA::SystemException exception) {
        cerr << "CORBA::ORB::string_to_object";
        return -1;
    }
  
    // Narrow the object reference to a HelloWorld CORBA object.
    HelloWorld_var hello_world;
    try {
        hello_world = HelloWorld::_narrow (object.in());
    }
    catch (CORBA::SystemException exception) {
        cerr << "HeloWorld::_narrow";
        return -1;
    }

    // now lets start interacting with the object in the server.

    // make the hello_world object say hello.
    try {
        hello_world->sayHello();
    }
    catch (CORBA::SystemException exception) {
        cerr << "HelloWorld::sayHello";
        return -1;
    }

    // Read back what the hello_world object tells us...
    const char* prompt = "gimme something: ";
    cout << "about to invoke 'readMessage' on the remote object." << endl;
#ifdef __TAO__
    CORBA::String message;
#else
    char* message;
#endif
    try {
        CORBA::Long message_len = hello_world->readMessage(prompt, message);
        // print the read message
        cout << "readMessage returned '" << message << "'." << endl;
        cout << "   message size '" << message_len << "' characters." << endl;
    }
    catch (CORBA::SystemException exception) {
        cerr << "HelloWorld::readMessage";
        return -1;
    }

    return 0;
}
