#!/usr/bin/perl -w

# config section.
$toc_per_slide = 1;

# end config section.

$out="./";
$pre="";
$toc="";
$toclvl=1;
$ma="";

sub outhtml {
  my ($bf,$counter,$last) = @_;
  my ($prev,$next,$next_toc,$myhead,$links);
  my ($slide) = "";
  #open(HTML,">${out}node$counter.html") or die "Can't write file $counter";
  $prev="node".($counter-1).".html" if ($counter>1);
  $next="node".($counter+1).".html" unless ($last);
  $next_toc="toc".($counter+1).".html" unless ($last);
  $links='<link rel="contents" href="index.html">';
  $links.='<link rel="top" href="index.html">';
  $links.='<link rel="start" href="node1.html">';
  $links.='<link rel="first" href="node1.html">';
  $links.="<link rel=\"next\" href=\"$next#h\">" if $next;
  $links.="<link rel=\"prev\" href=\"$prev#h\">" if $prev;
  $myhead=$head;
  $myhead =~ s{<!-- LINKS -->}{$links};
  $slide .= $myhead;
  $slide .= '<div class="nav">';
  $slide .= '<A HREF="index.html" NAME="h" accesskey=t>[Top]</A> <A HREF="node1.html#h">[First]</A>';
  if ($prev) {
    $slide .= "<A HREF=\"$prev#h\" accesskey=p>[Previous]</A> ";
  } else {
    $slide .= "[Previous] ";
  }
  unless ($next) {
    $slide .= "[Next]";
  } else {
    my $slide_data = $ma;
    $slide_data =~ s{<a[^>]+></a>}{}go;
    $slide_data =~ s{<h([234])[^>]*>(.+)</h[234]>}{<li><a href="node$counter.html#h">$2</a>\n}go;
    my $nextlvl=$1;
    $slide .= "<A HREF=\"node@{[$counter+1]}.html#h\" accesskey=n>[Next]</A>";
    if ($toc_per_slide) {
        my $nexttoc_accel="c";
        if ($nextlvl < $toclvl) {
            print STDERR "nextlvl - $nextlvl, toclvl - $toclvl\n";
            $nexttoc_accel="n";
        }
        $slide .= " <A HREF=\"toc@{[$counter+1]}.html#h\" accesskey=${nexttoc_accel}>[nexttoC]</A>";
    }
  }
  $slide .= '</div>';
  $slide .= $pre . $bf . $foot;
  #close (HTML);
  $pre =~ s{<a[^>]+></a>}{}go;
  $pre =~ s{<h([234])[^>]*>(.+)</h[234]>}{<li><a href="node$counter.html#h">$2</a>\n}go;
  my $newlvl=$1;
  if ($newlvl>$toclvl) {
    while ($toclvl<$newlvl) {
      $toc.="<ul class=\"lvl$toclvl\">\n";
      $toc.="<li>" if (++$toclvl<$newlvl);
    }
  } else {
    $toc.="</li></ul>" x ($toclvl-$newlvl);
    $toc.="</li>";
    $toclvl=$newlvl;
  }
  $toc.=$pre;

  return $slide;
}

$_=join('',<>);
$whole_input=$_;

($head,$_) = split('<!-- BEGIN -->');
($_,$foot) = split('<!-- END -->');

my ($tocinfo,$tochead,$tocfoot);

($head,$tocinfo)    = split('<!-- TOC',$head);
($tochead,$tocinfo) = split('<toc/>',$tocinfo);
($tocfoot,$tocinfo) = split('TOC -->',$tocinfo);
$head.=$tocinfo;

my @titles = ();
my @slides = ();

my $counter = 1;

while (m{<h[234][^>]*>.+</h[234]>}) {
  my ($bf);
  ($bf,$ma,$_)=($`,$&,$');
  unless ($bf =~ /\w/) {
    $pre.=$ma;
    next;
  }
  my $title = $ma;
  $title =~ s{^.*</a>}{};
  $title =~ s{</h[234]>$}{};
  push(@titles, $title);
  push @slides, outhtml($bf,$counter++,0);
  $pre=$ma;
}

push @slides, outhtml($_,$counter++,1);

for (my $curr_counter=1; $curr_counter < $counter; $curr_counter++) {
  # add a name to the 'Next' link (in all but the last slide)
  my $slide = $slides[$curr_counter - 1];
  if ($curr_counter < $counter - 2) {
    my $next_title = $titles[$curr_counter - 1];
    $next_title =~ s{.*}{\L<font size=-1>$&</font>\E};
    $slide =~ s/\[Next\]/[Next ($next_title)]/;
  }
  open(HTML,">${out}node${curr_counter}.html") or die "Can't write file $curr_counter";
  print HTML $slide;
  close (HTML) or die "Can't close file $curr_counter";
}

sub outhtml_toc {
  my ($bf,$counter,$last) = @_;
  my ($prev,$next,$myhead,$links);
  my ($slide) = "${out}node$counter.html";
  $prev="node".($counter-1).".html" if ($counter>1);

  open(HTML,">${out}toc$counter.html") or die "Can't write file toc$counter";
  my ($my_toc) = $toc;
  $my_toc =~ s{<a href="node$counter.html#h">(.*)</a>}{<a name="h"></a><span class="chosen_link"><a href="node$counter.html#h" accesskey=n background=black>$1</a></span>};
  print HTML $tochead,$my_toc,"</ul>"x($toclvl-1),$tocfoot;
  close (HTML);
}

if ($toc_per_slide) {
  my $counter = 1;

  $_ = $whole_input;

  while (m{<h[234][^>]*>.+</h[234]>}) {
    my ($bf,$ma);
    ($bf,$ma,$_)=($`,$&,$');
    unless ($bf =~ /\w/) {
      $pre.=$ma;
      next;
    }
    outhtml_toc($bf,$counter++,0);
    $pre=$ma;
  }

  outhtml_toc($_,$counter,1);
}

print $tochead,$toc,"</ul>"x($toclvl-1),$tocfoot;
