/*
 * For a description of the algorithm and the terms used, please see the
 * documentation for this sample.
 *
 * Each work-item invocation of this kernel, calculates the position for
 * one particle
 *
 * Work-items use local memory to reduce memory bandwidth and reuse of data
 */



__kernel void
nbody_sim(
    __global float4* pos ,
    __global float4* vel,
    int numBodies,
    float deltaTime,
    float epsSqr,
    __local float4* localPos,
    __global float4* newPosition,
    __global float4* newVelocity)

{
    unsigned int gid = get_global_id(0);

    // position of this work-item
    float4 myPos = pos[gid];
    float4 acc = (float4)(0.0f, 0.0f, 0.0f, 0.0f);

    // implement the rest of the kernel based on the CPU reference code
    // pos x/y/z are 3d coordinates
    // pos w is mass
    // same for newPosition


}

