#include <GL/glut.h>


#include "NBody.h"
#include "displayutils.h"
#include <iostream>
#include <fstream>
#include <cstdlib>


/**
* @brief Initialize GL
*/
void
GLInit()
{
    glClearColor(0.0 ,0.0, 0.0, 0.0);
    glClear(GL_COLOR_BUFFER_BIT);
    glClear(GL_DEPTH_BUFFER_BIT);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
}

/**
* @brief Glut Idle function
*/
void
idle()
{
    glutPostRedisplay();
}

/**
* @brief Glut reshape func
*
* @param w numParticles of OpenGL window
* @param h height of OpenGL window
*/
void
reShape(int w,int h)
{
    glViewport(0, 0, w, h);

    glViewport(0, 0, w, h);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    gluPerspective(45.0f, w/h, 1.0f, 1000.0f);
    gluLookAt (0.0, 0.0, -2.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0);
}

void NBody::printStats()
{
    std::string strArray[4] =
    {
        "Particles",
        "Iterations",
        "Time(sec)",
        "kernelTime(sec)"
    };

    std::string stats[4];

}



