#include <GL/glut.h>
#include <cmath>
#include <malloc.h>

#include <CL/cl.h>



#include "displayutils.h"
#include "NBody.h"

void parse_args(int argc, char * argv[], NBody * clNBody);

int main(int argc, char * argv[])
{
    NBody clNBody;
    parse_args(argc, argv, &clNBody);

    extern void * me;
    me = &clNBody;

    if(clNBody.initialize() != SUCCESS)
        exit(1);

    if(clNBody.setup() != SUCCESS)
        exit(1);
    if(clNBody.setupCLKernels() != SUCCESS)
        exit(1);
    if(clNBody.verifyResults() != SUCCESS)
        exit(1);

    clNBody.printStats();
    int display = 1;
    if(display)
    {
        // Run in  graphical window if requested
        glutInit(&argc, argv);
        glutInitWindowPosition(100,10);
        glutInitWindowSize(600,600);
        glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE );
        glutCreateWindow("nbody simulation");
        GLInit();
        glutDisplayFunc(displayfunc);
        glutReshapeFunc(reShape);
        glutIdleFunc(idle);
        glutKeyboardFunc(keyboardFunc);
        glutMainLoop();
    }

    if(clNBody.cleanup()!= SUCCESS)
        exit(1);

    return 1;
}


void parse_args(int argc, char * argv[], NBody * clNBody)
{

    if(argc == 4)
    {
        int n_ip = atoi(argv[1]);
        printf("Using %d Bodies \n",n_ip);
        clNBody->numParticles = n_ip;
        int ver_flag = atoi(argv[2]);
        if(ver_flag == 0)
            clNBody->verify = 0;
        else if(ver_flag == 1)
            clNBody->verify = 1;
        else
        {
            printf("Verify is 0 (No Verify) / 1 (Verify)\n");
            exit(1);
        }
        int kernel_type = atoi(argv[3]);
        if(kernel_type == BASIC)
            clNBody->kernel_type = BASIC;
        else if(kernel_type == REUSE)
            clNBody->kernel_type = REUSE;
        else if(kernel_type == UNROLL)
            clNBody->kernel_type = UNROLL;
        else
        {
            printf("Kernel Type\n");
            printf("\t\t 0 (BASIC Kernel ) \t\t 1 (REUSE Kernel) \n\t\t 2 (UNROLL Kernel)");
            exit(1);
        }
    }
    else
    {
        printf("Invalid No of Arguments - Has to be 3 arguments with executable\n");
        printf("./nbody N \t 0/1 \t Type\n");
        printf("1st Param\t N = No of Bodies\n");
        printf("2nd Param\t 0 = No Serial Verification\t 1 = With Serial Verification\n");
        printf("3rd Param\t Kernel Type\n");
        printf("\t\t0 = BASIC Kernel \t\t1 = REUSE Kernel \n\t\t2 = UNROLL Kernel\n");
        printf("Device Choices will be offered at runtime");
        exit(1);
    }
}
