#include <string>
#include <iostream>

#include "logger.h"

extern"C"{
     //for syslog
#include <syslog.h>
}

bool logger::_use_syslog = false;


void logger::log(const char* msg)
{
     if (logger::_use_syslog){
	  syslog(LOG_ERR, msg);
     }else{
	  cerr<<msg<<endl;
     }
}

void logger::log(const string& msg)
{
     log(msg.c_str());
}

void logger::open_syslog(const char* progname)
{
     openlog(progname, LOG_PID, LOG_NOTICE | LOG_USER);
}

void logger::close_syslog()
{
     closelog();
}
