#include "param_conditional.h"
#include "logger.h"

#include <iostream>
#include "validity_checks.h"

extern "C"{
#include <stdlib.h>
}

param_conditional::param_conditional()
{
     _val.type = DT_LAST_TYPE;
     _val.val.str = NULL;
}

param_conditional::~param_conditional()
{
     if (_val.type == DT_STRING) 
	  delete[] (_val.val.str);
}

param_conditional::param_conditional(const param_conditional& rhs)
{
     if (rhs._val.type == DT_STRING){
	  _val.type = DT_STRING;
	  if (rhs._val.val.str){
	       _val.val.str = new char[strlen(rhs._val.val.str)+1];
	       strcpy(_val.val.str, rhs._val.val.str);
	  }else {
	       _val.val.str = NULL;
	  }
     }else {
	  _val = rhs._val;
     }
     _loc = rhs._loc;
     _op = rhs._op;
}


ostream& operator<<(ostream& os, param_conditional& prm)
{
     os<<"param conditional: "<<endl;
     os<<"\tparam at location: "<<prm._loc<<" should be ";
     switch(prm._op){
	  case(OT_EQUAL):
	       os<<"equal";
	       break;
     case(OT_LESS):
	  os<<"less than";
	  break;
     case(OT_GREATER):
	  os<<"greater than";
	  break;
     case(OT_LESS_EQUAL):
	  os<<"less or equal than";
	  break;
     case(OT_GREATER_EQUAL):
	  os<<"greater or equal than";
	  break;
     case(OT_NOT_EQUAL):
	  os<<"not equal to";
	  break;
     default:
	  os<<"\n!! an unknown operand !!\n";
     }
     //print the value 
     os<<"\t"<<prm._val<<endl;
     return os;
}



void param_conditional::set_location(const string& str)
{
     if (is_int(str)){
	  _loc = atoi(str.c_str());
     }else{
	  cerr<<"set_location: '"<<str<<"' is not a number!"<<endl;
     }
}

void param_conditional::set_operand(const string& str )
{
     if (is_operand(str)){
	  if (str=="=="){
	       _op = OT_EQUAL;
	  }else if (str=="<"){
	       _op = OT_LESS;
	  }else if (str==">"){
	       _op = OT_GREATER;
	  }else if (str=="<="){
	       _op = OT_LESS_EQUAL;
	  }else if (str==">="){
	       _op = OT_GREATER_EQUAL;
	  }else if (str=="!="){
	       _op = OT_NOT_EQUAL;
	  }

     }else{
	  cerr<<"set_operand: '"<<str<<"' is not an operand!"<<endl;
     }     
}

void param_conditional::set_type(const string& str)
{
     if (is_param_type(str)){
	  if (str=="b"){
	       _val.type = DT_BOOL;
	  }else if (str=="c"){
	       _val.type = DT_CHAR;
	  }else if (str=="i"){
	       _val.type = DT_INT;
	  }else if (str=="s"){
	       _val.type = DT_SHORT;
	  }else if (str=="l"){
	       _val.type = DT_LONG;
	  }else if (str=="f"){
	       _val.type = DT_FLOAT;
	  }else if (str=="str"){
	       _val.type = DT_STRING;
	  }
     }else{
	  cerr<<"set_type: '"<<str<<"' is not a valid param type!"<<endl;
     }
}

void param_conditional::set_value(const string& str)
{
     //check that the user has already set the type of the param. 
     if (_val.type == DT_LAST_TYPE){
	  cerr<<"set_value: can't set the value if the type is not set!"<<endl;
	  return;
     }
     switch (_val.type){
     case(DT_BOOL):
	  if (str=="true"){
	       _val.val.b = true;
	  }else if (str=="false"){
	       _val.val.b = false;
	  }
	  break;
     case(DT_CHAR):
	  _val.val.c = (char)atoi(str.c_str());
	  break;
     case(DT_INT):
	  _val.val.i = atoi(str.c_str());
	  break;
     case(DT_SHORT):
	  _val.val.s = (short)atoi(str.c_str());
	  break;
     case(DT_LONG):
	  _val.val.l = atol(str.c_str());
	  break;
     case(DT_FLOAT):
	  _val.val.f = atof(str.c_str());
	  break;
     case(DT_STRING):
	  _val.val.str = new char[str.size()+1];
	  if (!_val.val.str){
	       cerr<<"set_value: failed to alloc memory for a char array"<<endl;
	       return;
	  }
	  strcpy(_val.val.str, str.c_str());
	  break;
     case(DT_LAST_TYPE):
     default:
	  cerr<<"set_value called without a type"<<endl;
     }
}
