#include "param_types.h"

#include <iostream>

ostream& operator<<(ostream& os, value_type_t& vt)
{
     os<<" value is: ";
     switch(vt.type){
     case(DT_BOOL):os<<"bool: "<<vt.val.b;
	  break;
     case(DT_CHAR):os<<"char: "<<vt.val.c;
	  break;
     case(DT_INT):os<<"int: "<<vt.val.i;
	  break;
     case(DT_SHORT):os<<"short: "<<vt.val.s;
	  break;
     case(DT_LONG):os<<"long: "<<vt.val.l;
	  break;
     case (DT_FLOAT):os<<"float: "<<vt.val.f;
	  break;
     case (DT_STRING):os<<"string: "<<
			   (vt.val.str) ? vt.val.str : "NULL";
	  break;
     case (DT_LAST_TYPE):os<<"last value!";
	  break;
     default:
	  os<<"*** unknown type! ***";
	  break;
     }
     return os;
}
