#ifndef _PARAM_TYPES_H_
#define _PARAM_TYPES_H_

#include <iostream>

typedef enum {
     OT_EQUAL = 0,
     OT_LESS,
     OT_GREATER,
     OT_LESS_EQUAL,
     OT_GREATER_EQUAL,
     OT_NOT_EQUAL,
     OT_PLUS,
     OT_MINUS,
     OT_BIT_SHIFT_LEFT,
     OT_BIT_SHIFT_RIGHT,
     OT_BIT_AND,
     OT_BIT_OR,
     OT_BIT_XOR,
     OT_BIT_NOT,
     OT_LOGIC_AND,
     OT_LOGIC_OR,
     OT_LOGIC_NOT,
     OT_PATTERN_MATCH,
     OT_LAST_OPERATOR
} oper_type_t;

typedef oper_type_t operand;

typedef enum {
     PID = 0,
     PPID,
     UID,
     EUID,
     LAST_PROCESS_FIELD
} process_field_t;

typedef enum {
	DT_BOOL = 0,
	DT_CHAR,
	DT_INT,
	DT_SHORT,
	DT_LONG,
	DT_FLOAT,
	DT_STRING,
	DT_LAST_TYPE
} data_type_t;


union value_data_t{
     int b;          /* bool   */
     char c;         /* char   */
     int i;          /* int    */
     long l;         /* int    */
     short s;        /* short  */
     float f;        /* float  */
     char* str;      /* string */
};

struct value_type_t {
     data_type_t type;
     value_data_t val;
};

ostream& operator<<(ostream& os, value_type_t& vt);

#endif

