/*  parser is responsible of parsing the configuration file, as defined in 
 *  the config.file document. it then builds a list of rules which can
 *  sent to the module
 *
 *  @author: mulix@actcom.co.il
 */

#ifndef _PARSER_H_
#define _PARSER_H_

#include <string>
#include <strstream>

#include "token.h"
#include "rule.h"
#include "process_conditional.h"
#include "param_conditional.h"


class parser
{
 public:
     /* constructor.
	@param: the configuration data, passed as a strstream  */
     parser(strstream& config_data);

     /* parse is the one and only entry point into the parser. 
	if the parsing failed the function will return it. 
	if the parsing of any rule is successful, we return the 
	parsed rules in the rules list. 
        returns true if parsing of ALL rules was successful.    */
     bool parse(list<rule>& rules);

 private:
     /* parse_rule accepts a string of rule data and parses it into a 
	rule structure. */
     bool parse_rule(rule& r, const string& data);

     /* read_token does most of the parsing. it accepts a string of rule
	data and a position to start parsing from. 
	it returns a token class with data about the parsed token, and 
	the position to start the next parsing from */
     bool read_token(token& t, const string& rule, string::size_type*
		     pos);

     /* validate_rule accepts a rule structure and makes sure that it is 
	a valid rule which can be forwarded to the kernel module. */
     bool validate_rule(const rule& r);

     /* parse_process_condition accepts a process_conditional structure 
	and a string of rule data. it parses the data and fills the 
	process conditional. */
     bool parse_process_condition(process_conditional* pcond, const string& data);

     /* parse_process_condition accepts a param_conditional structure 
	and a string of rule data. it parses the rule data and fills
	the param_conditional structure. */
     bool parse_param_condition(param_conditional* pcond, 
				const string& data);

     /* log_error accepts a function name, a message and an incorrectly parsed
	token (the token does not contain the values it should contain). it logs
	the error using 'logger'. */
     void log_error(const char* func_name, const char* msg, const token& t);
	  
     /* log_error accepts a function name, a message and string of data. to report 
	parse_errors when we haven't built a token yet */
     void log_error(const char* func_name, const char* msg, const string& data);

     /* members */
     strstream& _data;
};

#endif
