#include "process_conditional.h"
#include "validity_checks.h"

#include <iostream>

ostream& operator<<(ostream& os, process_conditional& prc)
{
     os<<"processs conditional: "<<endl;
     os<<"\tprocess_field: ";
     switch (prc._proc_field){
     case(PID):os<<"PID"<<endl;
	  break;
     case(PPID):os<<"PPID"<<endl;
	  break;
     case(UID):os<<"UID"<<endl;
	  break;
     case(EUID):os<<"EUID"<<endl;
	  break;
     default:os<<"*** unnknown type ***"<<endl;
	  break;
	  
     }
     os<<"\t"<<prc._val<<endl;
     return os;
}

void process_conditional::set_process_field(const string& str)
{
     if (is_process_field(str)){
	  if (str=="PPID"){
	       _proc_field = PPID;
	  }else if (str=="PID"){
	       _proc_field = PID;
	  }else if (str=="UID"){
	       _proc_field = UID;
	  }else if (str=="EID"){
	       _proc_field = EUID;
	  }
     }else{
	  _proc_field = LAST_PROCESS_FIELD;
	  cerr<<"set_process_field: '"<<str<<"' is not a valid process_field"<<endl;
     }
}

void process_conditional::set_value(const string& val)
{
     if (is_long(val)){
	  _val = atol(val.c_str());
     }else{
	  cerr<<"proc_conditional::set_value: '"<<val
	      <<"' is not a valid long value"<<endl;
     }
}

bool process_conditional::is_valid()
{
     if (_proc_field == LAST_PROCESS_FIELD){
	  return false;
     }
     return true;
}
