#include <stdio.h>
#include <gtk/gtk.h>

/*
 * callback event function for the gtk delete event. invoked
 * when the application is closed using the window manager.
 */
int
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    /* If you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs.
     */
 
    return(FALSE);
}


/* exit the application. */
void
exit_cb(GtkWidget* widget, gpointer data)
{
    gtk_main_quit();
}

/* callback invoked when row(s) in the 'clist' is seleced. */
void
clist_selection_cb(GtkCList* clist,
		gint from_row,
		gint num_rows,
		GdkEvent* event,
		gpointer data)
{
    printf("Rows selected params %d, %d\n", from_row, num_rows);
    printf("Rows selected %d-%d\n", from_row, from_row+num_rows-1);
    printf("=================================================\n");
    fflush(stdout);
}

/* callback invoked when row(s) in the 'clist' is un-seleced. */
void
clist_unselection_cb(GtkCList* clist,
		  gint from_row,
		  gint num_rows,
		  GdkEvent* event,
		  gpointer data)
{
    printf("Rows UN-selected params %d, %d\n", from_row, num_rows);
    printf("Rows UN-selected %d-%d\n", from_row, from_row+num_rows-1);
    printf("-------------------------------------------------\n");
    fflush(stdout);
}

int
main(int argc, char* argv[])
{
    /* this variable will store a pointer to the window object. */
    GtkWidget* main_window;
    /* this will store a horizontal box. */
    GtkWidget* hbox;
    /* this will store a table. */
    GtkWidget* clist;


    /* This is called in all GTK applications. Arguments */
    /* are parsed from the command line and are returned */
    /* to the application.                               */
    gtk_init(&argc, &argv);

    /* create a new top-level window. */
    main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    /* define some of the window's attributes. */
    gtk_window_set_title(GTK_WINDOW (main_window),
                         "A Top Window For The Rest Of Us...");
    gtk_container_set_border_width(GTK_CONTAINER (main_window), 5);

    /* make the window visible. */
    gtk_widget_show(main_window);

    /* When the window is given the "delete_event" signal (this is given
     * by the window manager, usually by the "close" option, or on the
     * titlebar), we ask it to call the delete_event() function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "delete_event",
                       GTK_SIGNAL_FUNC (delete_event), NULL);

    /* Here we connect the "destroy" event to a signal handler.
     * This event occurs when we call gtk_widget_destroy() on the window,
     * or if we return FALSE in the "delete_event" callback.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "destroy",
                       GTK_SIGNAL_FUNC (exit_cb), NULL);

    /* create a new horizontal box, make it non-homogenous, */
    /* and with 0 spacing between its contained widgets.    */
    /* place it in the top window, make it visible.	    */
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(main_window), hbox);
    gtk_widget_show(hbox);


    {
	/* create a new clist with 4 columns. make it visible. */
	gchar* titles[] = {"File", "Site", "% Done", "ETA"};
	clist = gtk_clist_new_with_titles(4, titles);
	gtk_widget_show(clist);

	/* set the width for each column, in 'pixel' units. */
	gtk_clist_set_column_width(GTK_CLIST(clist), 0, 150);
	gtk_clist_set_column_width(GTK_CLIST(clist), 1, 100);
	gtk_clist_set_column_width(GTK_CLIST(clist), 2, 85);
	gtk_clist_set_column_width(GTK_CLIST(clist), 3, 85);

	/* insert a few rows of data into the clist. */
	{
	    gchar* row0[] = {"/ls-LR", "ftp.uu.net", "0%", "5:47"};
	    gchar* row1[] = {"/pub/README", "ftp.uu.net", "5%", "00:17"};
	    gchar* row2[] = {"/pub/INDEX", "ftp.uu.net", "85%", "00:05"};
	    gchar* row3[] = {"/pub/file1.tar.gz", "ftp.uu.net", "1%", "01:55"};
	    gchar* row4[] = {"/pub/file2.tar.gz", "ftp.uu.net", "12%", "19:17"};

	    gtk_clist_append(GTK_CLIST(clist), row0);
	    gtk_clist_append(GTK_CLIST(clist), row1);
	    gtk_clist_append(GTK_CLIST(clist), row2);
	    gtk_clist_append(GTK_CLIST(clist), row3);
	    gtk_clist_append(GTK_CLIST(clist), row4);
	}
	/* register callbacks to be invoked when a row is */
	/* selected/deselected.                           */
	gtk_signal_connect(GTK_OBJECT(clist), "select-row",
                   	GTK_SIGNAL_FUNC(clist_selection_cb),
                   	(gpointer)clist);
	gtk_signal_connect(GTK_OBJECT(clist), "unselect-row",
                   	GTK_SIGNAL_FUNC(clist_unselection_cb),
                   	(gpointer)clist);
	/* add the clist to the top-window's hbox. */
	gtk_box_pack_start(GTK_BOX(hbox), clist, TRUE, TRUE, 1);
    }


    /* All GTK applications must have a gtk_main(). Control
     * ends here and waits for an event to occur (like a
     * key press or mouse event).
     */
    gtk_main();

    exit(0);
}
