#include <gtk/gtk.h>

/*
 * callback event function for the gtk delete event. invoked
 * when the application is closed using the window manager.
 */
int
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    /* If you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs.
     */
 
    return(FALSE);
}


/* exit the application. */
void
exit_cb(GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

int
main(int argc, char* argv[])
{
    /* this variable will store a pointer to the window object. */
    GtkWidget* main_window;
    /* this will store a horizontal box. */
    GtkWidget* hbox;
    /* these will store the vertical boxes. */
    GtkWidget* vbox1;
    GtkWidget* vbox2;
    /* these will store push buttons. */
    GtkWidget* button11;
    GtkWidget* button12;
    GtkWidget* button21;
    GtkWidget* button22;


    /* This is called in all GTK applications. Arguments */
    /* are parsed from the command line and are returned */
    /* to the application.                               */
    gtk_init(&argc, &argv);

    /* create a new top-level window. */
    main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    /* define some of the window's attributes. */
    gtk_window_set_title(GTK_WINDOW (main_window),
                         "A Top Window For The Rest Of Us...");
    gtk_container_set_border_width(GTK_CONTAINER (main_window), 5);

    /* make the window visible. */
    gtk_widget_show(main_window);

    /* When the window is given the "delete_event" signal (this is given
     * by the window manager, usually by the "close" option, or on the
     * titlebar), we ask it to call the delete_event() function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "delete_event",
                       GTK_SIGNAL_FUNC (delete_event), NULL);

    /* Here we connect the "destroy" event to a signal handler.
     * This event occurs when we call gtk_widget_destroy() on the window,
     * or if we return FALSE in the "delete_event" callback.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "destroy",
                       GTK_SIGNAL_FUNC (exit_cb), NULL);

    /* create 4 push buttons. */
    button11 = gtk_button_new_with_label("11");
    button12 = gtk_button_new_with_label("12");
    button21 = gtk_button_new_with_label("21");
    button22 = gtk_button_new_with_label("22");
    /* make the buttons visible. */
    gtk_widget_show(button11);
    gtk_widget_show(button12);
    gtk_widget_show(button21);
    gtk_widget_show(button22);

    /* create a new horizontal box, make it non-homogenous, */
    /* and with 0 spacing between its contained widgets.    */
    hbox = gtk_hbox_new(FALSE, 0);

    /* add it to the top-level window. */
    gtk_container_add(GTK_CONTAINER(main_window), hbox);

    /* make it visible. */
    gtk_widget_show(hbox);

    /* create two vertical boxes. both non-homogenous, and */
    /* with 0 spacing between their contained widgets.     */
    vbox1 = gtk_vbox_new(FALSE, 0);
    vbox2 = gtk_vbox_new(FALSE, 0);

    /* place the two v-boxes inside our hbox. */
    gtk_box_pack_start(GTK_BOX(hbox), vbox1, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(hbox), vbox2, TRUE, TRUE, 1);

    /* make our v-boxes visible. */
    gtk_widget_show(vbox1);
    gtk_widget_show(vbox2);

    /* place 4 buttons in the v-boxes, 2 in each. */
    gtk_box_pack_start(GTK_BOX(vbox1), button11, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(vbox1), button12, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(vbox2), button21, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(vbox2), button22, TRUE, TRUE, 1);


    /* All GTK applications must have a gtk_main(). Control
     * ends here and waits for an event to occur (like a
     * key press or mouse event).
     */
    gtk_main();

    exit(0);
}
