#include <unistd.h>
#include <gtk/gtk.h>

/*
 * callback event function for the gtk delete event. invoked
 * when the application is closed using the window manager.
 */
int
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    /* If you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs.
     */
 
    return(FALSE);
}


/* exit the application. */
void
exit_cb(GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

int
main(int argc, char* argv[])
{
    /* this variable will store a pointer to the window object. */
    GtkWidget* main_window;
    /* this will store a label. */
    GtkWidget* label;


    /* This is called in all GTK applications. Arguments */
    /* are parsed from the command line and are returned */
    /* to the application.                               */
    gtk_init(&argc, &argv);

    /* create a new top-level window. */
    main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    /* define some of the window's attributes. */
    gtk_window_set_title(GTK_WINDOW (main_window),
                         "A Top Window For The Rest Of Us...");
    gtk_container_set_border_width(GTK_CONTAINER (main_window), 5);

    /* make the window visible. */
    gtk_widget_show(main_window);

    /* When the window is given the "delete_event" signal (this is given
     * by the window manager, usually by the "close" option, or on the
     * titlebar), we ask it to call the delete_event() function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "delete_event",
                       GTK_SIGNAL_FUNC (delete_event), NULL);

    /* Here we connect the "destroy" event to a signal handler.
     * This event occurs when we call gtk_widget_destroy() on the window,
     * or if we return FALSE in the "delete_event" callback.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "destroy",
                       GTK_SIGNAL_FUNC (exit_cb), NULL);

    /* create a label. */
    label = gtk_label_new("Uneditable Text");

    /* add the label to the top-level window. */
    gtk_container_add(GTK_CONTAINER(main_window), label);

    /* make the label visible. */
    gtk_widget_show(label);

    /* just a trick to cause waiting until the screen refreshes. */
    sleep(1);
    while (gtk_events_pending()) {
	gtk_main_iteration();
    }
    sleep(2);

    /* change the text of our label. */
    gtk_label_set_text(GTK_LABEL(label), "U-n-e-d-i-t-a-b-l-e T-e-x-t");
    

    /* All GTK applications must have a gtk_main(). Control
     * ends here and waits for an event to occur (like a
     * key press or mouse event).
     */
    gtk_main();

    exit(0);
}
