#include <gtk/gtk.h>

/*
 * callback event function for the gtk delete event. invoked
 * when the application is closed using the window manager.
 */
int
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    /* If you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs.
     */
 
    return(FALSE);
}


/* exit the application. */
void
exit_cb(GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

int
main(int argc, char* argv[])
{
    /* this variable will store a pointer to the window object. */
    GtkWidget* main_window;
    /* this will store a gtk packer. */
    GtkWidget* packer;
    /* these will store push buttons. */
    GtkWidget* button1;
    GtkWidget* button2;
    GtkWidget* button3;
    GtkWidget* button4;


    /* This is called in all GTK applications. Arguments */
    /* are parsed from the command line and are returned */
    /* to the application.                               */
    gtk_init(&argc, &argv);

    /* create a new top-level window. */
    main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    /* define some of the window's attributes. */
    gtk_window_set_default_size(GTK_WINDOW(main_window), 200, 200);
    gtk_window_set_title(GTK_WINDOW (main_window),
                         "A Top Window For The Rest Of Us...");
    gtk_container_set_border_width(GTK_CONTAINER (main_window), 5);

    /* make the window visible. */
    gtk_widget_show(main_window);

    /* When the window is given the "delete_event" signal (this is given
     * by the window manager, usually by the "close" option, or on the
     * titlebar), we ask it to call the delete_event() function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "delete_event",
                       GTK_SIGNAL_FUNC (delete_event), NULL);

    /* Here we connect the "destroy" event to a signal handler.
     * This event occurs when we call gtk_widget_destroy() on the window,
     * or if we return FALSE in the "delete_event" callback.
     */
    gtk_signal_connect(GTK_OBJECT (main_window), "destroy",
                       GTK_SIGNAL_FUNC (exit_cb), NULL);

    /* create 4 push buttons. */
    button1 = gtk_button_new_with_label("1");
    button2 = gtk_button_new_with_label("2");
    button3 = gtk_button_new_with_label("3");
    button4 = gtk_button_new_with_label("4");
    /* make the buttons visible. */
    gtk_widget_show(button1);
    gtk_widget_show(button2);
    gtk_widget_show(button3);
    gtk_widget_show(button4);

    /* allocate a new packer */
    packer = gtk_packer_new();

    /* place the packer inside the top-level window. */
    gtk_container_add(GTK_CONTAINER(main_window), packer);

    /* make the packer visible. */
    gtk_widget_show(packer);

    /* place a button at the top, connected to the 'northern' edge. */
    /* use no special options, a border width of 1, and with the    */
    /* given padding values.                                        */
    gtk_packer_add(GTK_PACKER(packer), button1,
                   GTK_SIDE_TOP, GTK_ANCHOR_NORTH,
                   0, 1, 0, 0, 1, 1);

    /* and add 3 other buttons. */
    gtk_packer_add(GTK_PACKER(packer), button2,
                   GTK_SIDE_TOP, GTK_ANCHOR_EAST,
                   0, 1, 0, 0, 1, 1);
    gtk_packer_add(GTK_PACKER(packer), button3,
                   GTK_SIDE_BOTTOM, GTK_ANCHOR_WEST,
                   GTK_PACK_EXPAND, 1, 0, 0, 1, 1);
    gtk_packer_add(GTK_PACKER(packer), button4,
                   GTK_SIDE_BOTTOM, GTK_ANCHOR_SOUTH_EAST,
                   GTK_PACK_EXPAND|GTK_FILL_X, 1, 0, 0, 1, 1);


    /* All GTK applications must have a gtk_main(). Control
     * ends here and waits for an event to occur (like a
     * key press or mouse event).
     */
    gtk_main();

    exit(0);
}
